/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.maxent.Feature;
import edu.stanford.nlp.maxent.Problem;
import edu.stanford.nlp.maxent.iis.LambdaSolve;
import edu.stanford.nlp.tagger.maxent.TaggerFeature;
import java.io.DataInputStream;
import java.text.NumberFormat;

public class LambdaSolveTagger
extends LambdaSolve {
    LambdaSolveTagger(Problem p1, double eps1, byte[][] fnumArr) {
        this.p = p1;
        this.eps = eps1;
        this.lambda = new double[p1.fSize];
        this.probConds = new double[p1.data.xSize][p1.data.ySize];
        this.fnumArr = fnumArr;
        this.zlambda = new double[p1.data.xSize];
        this.ftildeArr = new double[this.p.fSize];
        this.initCondsZlambdaEtc();
    }

    LambdaSolveTagger(DataInputStream dataStream) {
        this.lambda = LambdaSolveTagger.read_lambdas(dataStream);
    }

    LambdaSolveTagger(double[] lambda) {
        this.lambda = lambda;
    }

    void initCondsZlambdaEtc() {
        int x;
        for (x = 0; x < this.p.data.xSize; ++x) {
            for (int y = 0; y < this.p.data.ySize; ++y) {
                this.probConds[x][y] = 1.0 / (double)this.p.data.ySize;
            }
        }
        System.err.println(" pcond initialized ");
        for (x = 0; x < this.p.data.xSize; ++x) {
            this.zlambda[x] = this.p.data.ySize;
        }
        System.err.println(" zlambda initialized ");
        for (int i = 0; i < this.p.fSize; ++i) {
            this.ftildeArr[i] = this.p.functions.get(i).ftilde();
            if (this.ftildeArr[i] != 0.0) continue;
            System.err.println(" Empirical expectation 0 for feature " + i);
        }
        System.err.println(" ftildeArr initialized ");
    }

    double g(double lambdaP, int index) {
        double s = 0.0;
        for (int i = 0; i < this.p.functions.get(index).len(); ++i) {
            int y = ((TaggerFeature)this.p.functions.get(index)).getYTag();
            int x = this.p.functions.get(index).getX(i);
            s += this.p.data.ptildeX(x) * this.pcond(y, x) * 1.0 * Math.exp(lambdaP * this.fnum(x, y));
        }
        return s -= this.ftildeArr[index];
    }

    double fExpected(Feature f) {
        TaggerFeature tF = (TaggerFeature)f;
        double s = 0.0;
        int y = tF.getYTag();
        for (int i = 0; i < f.len(); ++i) {
            int x = tF.getX(i);
            s += this.p.data.ptildeX(x) * this.pcond(y, x);
        }
        return s;
    }

    @Override
    public boolean checkCorrectness() {
        System.err.println("Checking model correctness; x size " + this.p.data.xSize + ' ' + ", ysize " + this.p.data.ySize);
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumFractionDigits(4);
        boolean flag = true;
        for (int f = 0; f < this.lambda.length; ++f) {
            if (!(Math.abs(this.lambda[f]) > 100.0)) continue;
            System.err.println(" Lambda too big " + this.lambda[f]);
            System.err.println(" empirical " + this.ftildeArr[f] + " expected " + this.fExpected(this.p.functions.get(f)));
        }
        for (int i = 0; i < this.ftildeArr.length; ++i) {
            double exp = Math.abs(this.ftildeArr[i] - this.fExpected(this.p.functions.get(i)));
            if (!(exp > 0.001)) continue;
            flag = false;
            System.err.println("Constraint " + i + " not satisfied emp " + nf.format(this.ftildeArr[i]) + " exp " + nf.format(this.fExpected(this.p.functions.get(i))) + " diff " + nf.format(exp) + " lambda " + nf.format(this.lambda[i]));
        }
        for (int x = 0; x < this.p.data.xSize; ++x) {
            int y;
            double s = 0.0;
            for (y = 0; y < this.p.data.ySize; ++y) {
                s += this.probConds[x][y];
            }
            if (!(Math.abs(s - 1.0) > 1.0E-4)) continue;
            for (y = 0; y < this.p.data.ySize; ++y) {
                System.err.println(y + " : " + this.probConds[x][y]);
            }
            System.err.println("probabilities do not sum to one " + x + ' ' + (float)s);
        }
        return flag;
    }
}

