/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.time;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.time.TimeAnnotations;
import edu.stanford.nlp.time.Timex;
import edu.stanford.nlp.time.XMLUtils;
import edu.stanford.nlp.util.ArrayCoreMap;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.DataFilePaths;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.SystemUtils;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class GUTimeAnnotator
implements Annotator {
    private static final String BASE_PATH = "$NLP_DATA_HOME/packages/GUTime";
    private static final String DEFAULT_PATH = DataFilePaths.convert("$NLP_DATA_HOME/packages/GUTime");
    private final File gutimePath;
    private final boolean outputResults;
    public static final String GUTIME_PATH_PROPERTY = "gutime.path";
    public static final String GUTIME_OUTPUT_RESULTS = "gutime.outputResults";

    public GUTimeAnnotator() {
        this(new File(System.getProperty("gutime", DEFAULT_PATH)));
    }

    public GUTimeAnnotator(File gutimePath) {
        this.gutimePath = gutimePath;
        this.outputResults = false;
    }

    public GUTimeAnnotator(String name, Properties props) {
        String path = props.getProperty(GUTIME_PATH_PROPERTY, System.getProperty("gutime", DEFAULT_PATH));
        this.gutimePath = new File(path);
        this.outputResults = Boolean.valueOf(props.getProperty(GUTIME_OUTPUT_RESULTS, "false"));
    }

    @Override
    public void annotate(Annotation annotation) {
        try {
            this.annotate((CoreMap)annotation);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    public void annotate(CoreMap document) throws IOException {
        Element outputXML;
        Element inputXML = GUTimeAnnotator.toInputXML(document);
        File inputFile = File.createTempFile("gutime", ".input");
        PrintWriter inputWriter = new PrintWriter(inputFile);
        inputWriter.println(XMLUtils.nodeToString(inputXML, false));
        inputWriter.close();
        boolean useFirstDate = !document.has(CoreAnnotations.CalendarAnnotation.class) && !document.has(CoreAnnotations.DocDateAnnotation.class);
        ArrayList<String> args = new ArrayList<String>();
        args.add("perl");
        args.add("-I" + this.gutimePath.getPath());
        args.add(new File(this.gutimePath, "TimeTag.pl").getPath());
        if (useFirstDate) {
            args.add("-FDNW");
        }
        args.add(inputFile.getPath());
        ProcessBuilder process = new ProcessBuilder(args);
        StringWriter outputWriter = new StringWriter();
        SystemUtils.run(process, outputWriter, null);
        String output = outputWriter.getBuffer().toString();
        Pattern docClose = Pattern.compile("</DOC>.*", 32);
        output = docClose.matcher(output).replaceAll("</DOC>");
        try {
            outputXML = XMLUtils.parseElement(output);
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("error:\n%s\ninput:\n%s\noutput:\n%s", ex, IOUtils.slurpFile(inputFile), output), ex);
        }
        inputFile.delete();
        List<CoreMap> timexAnns = GUTimeAnnotator.toTimexCoreMaps(outputXML, document);
        document.set(TimeAnnotations.TimexAnnotations.class, timexAnns);
        if (this.outputResults) {
            System.out.println(timexAnns);
        }
        int timexIndex = 0;
        for (CoreMap sentence : (List)document.get(CoreAnnotations.SentencesAnnotation.class)) {
            int sentBegin = GUTimeAnnotator.beginOffset(sentence);
            int sentEnd = GUTimeAnnotator.endOffset(sentence);
            while (timexIndex < timexAnns.size() && GUTimeAnnotator.beginOffset(timexAnns.get(timexIndex)) < sentBegin) {
                ++timexIndex;
            }
            int sublistBegin = timexIndex;
            int sublistEnd = timexIndex;
            while (timexIndex < timexAnns.size() && sentBegin <= GUTimeAnnotator.beginOffset(timexAnns.get(timexIndex)) && GUTimeAnnotator.endOffset(timexAnns.get(timexIndex)) <= sentEnd) {
                ++sublistEnd;
                ++timexIndex;
            }
            sentence.set(TimeAnnotations.TimexAnnotations.class, timexAnns.subList(sublistBegin, sublistEnd));
        }
    }

    private static int beginOffset(CoreMap ann) {
        return (Integer)ann.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
    }

    private static int endOffset(CoreMap ann) {
        return (Integer)ann.get(CoreAnnotations.CharacterOffsetEndAnnotation.class);
    }

    private static Element toInputXML(CoreMap document) {
        Element doc = XMLUtils.createElement("DOC");
        doc.appendChild(XMLUtils.createTextNode("\n"));
        Calendar dateCalendar = (Calendar)document.get(CoreAnnotations.CalendarAnnotation.class);
        if (dateCalendar != null) {
            Element date = XMLUtils.createElement("date");
            date.appendChild(XMLUtils.createTextNode(String.format("%TF", dateCalendar)));
            doc.appendChild(date);
            doc.appendChild(XMLUtils.createTextNode("\n"));
        } else {
            String s = (String)document.get(CoreAnnotations.DocDateAnnotation.class);
            if (s != null) {
                Element date = XMLUtils.createElement("date");
                date.appendChild(XMLUtils.createTextNode(s));
                doc.appendChild(date);
                doc.appendChild(XMLUtils.createTextNode("\n"));
            }
        }
        Element textElem = XMLUtils.createElement("text");
        doc.appendChild(textElem);
        doc.appendChild(XMLUtils.createTextNode("\n"));
        String text = (String)document.get(CoreAnnotations.TextAnnotation.class);
        int offset = 0;
        for (CoreMap sentence : (List)document.get(CoreAnnotations.SentencesAnnotation.class)) {
            int sentBegin = (Integer)sentence.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
            int sentEnd = (Integer)sentence.get(CoreAnnotations.CharacterOffsetEndAnnotation.class);
            textElem.appendChild(XMLUtils.createTextNode(text.substring(offset, sentBegin)));
            offset = sentBegin;
            Element s = XMLUtils.createElement("s");
            textElem.appendChild(s);
            for (CoreLabel token : (List)sentence.get(CoreAnnotations.TokensAnnotation.class)) {
                int tokenBegin = (Integer)token.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
                int tokenEnd = (Integer)token.get(CoreAnnotations.CharacterOffsetEndAnnotation.class);
                s.appendChild(XMLUtils.createTextNode(text.substring(offset, tokenBegin)));
                offset = tokenBegin;
                Element lex = XMLUtils.createElement("lex");
                s.appendChild(lex);
                String posTag = (String)token.get(CoreAnnotations.PartOfSpeechAnnotation.class);
                if (posTag != null) {
                    lex.setAttribute("pos", posTag);
                }
                assert (token.word().equals(text.substring(offset, tokenEnd)));
                lex.appendChild(XMLUtils.createTextNode(text.substring(offset, tokenEnd)));
                offset = tokenEnd;
            }
            textElem.appendChild(XMLUtils.createTextNode(text.substring(offset, sentEnd)));
            offset = sentEnd;
        }
        textElem.appendChild(XMLUtils.createTextNode(text.substring(offset, text.length())));
        return doc;
    }

    private static List<CoreMap> toTimexCoreMaps(Element docElem, CoreMap originalDocument) {
        Map<Integer, Integer> beginMap = Generics.newHashMap();
        Map<Integer, Integer> endMap = Generics.newHashMap();
        boolean haveTokenOffsets = true;
        for (CoreMap sent : (List)originalDocument.get(CoreAnnotations.SentencesAnnotation.class)) {
            for (CoreLabel token : (List)sent.get(CoreAnnotations.TokensAnnotation.class)) {
                Integer tokBegin = (Integer)token.get(CoreAnnotations.TokenBeginAnnotation.class);
                Integer tokEnd = (Integer)token.get(CoreAnnotations.TokenEndAnnotation.class);
                if (tokBegin == null || tokEnd == null) {
                    haveTokenOffsets = false;
                }
                int charBegin = (Integer)token.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
                int charEnd = (Integer)token.get(CoreAnnotations.CharacterOffsetEndAnnotation.class);
                beginMap.put(charBegin, tokBegin);
                endMap.put(charEnd, tokEnd);
            }
        }
        ArrayList<CoreMap> timexMaps = new ArrayList<CoreMap>();
        int offset = 0;
        NodeList docNodes = docElem.getChildNodes();
        Node textElem = null;
        for (int i = 0; i < docNodes.getLength(); ++i) {
            Node n = docNodes.item(i);
            if (!"text".equals(n.getNodeName())) continue;
            textElem = (Element)n;
            break;
        }
        NodeList textNodes = textElem.getChildNodes();
        for (int i = 0; i < textNodes.getLength(); ++i) {
            Node content = textNodes.item(i);
            if (content instanceof Text) {
                Text text = (Text)content;
                offset += text.getWholeText().length();
                continue;
            }
            if (content instanceof Element) {
                Element child = (Element)content;
                if (child.getNodeName().equals("TIMEX3")) {
                    Timex timex = new Timex(child);
                    if (child.getChildNodes().getLength() != 1) {
                        throw new RuntimeException("TIMEX3 should only contain text " + child);
                    }
                    String timexText = child.getTextContent();
                    ArrayCoreMap timexMap = new ArrayCoreMap();
                    timexMap.set(TimeAnnotations.TimexAnnotation.class, timex);
                    timexMap.set(CoreAnnotations.TextAnnotation.class, timexText);
                    int charBegin = offset;
                    timexMap.set(CoreAnnotations.CharacterOffsetBeginAnnotation.class, charBegin);
                    int charEnd = offset += timexText.length();
                    timexMap.set(CoreAnnotations.CharacterOffsetEndAnnotation.class, charEnd);
                    if (haveTokenOffsets) {
                        Integer tokBegin = (Integer)beginMap.get(charBegin);
                        int searchStep = 1;
                        while (tokBegin == null) {
                            tokBegin = (Integer)beginMap.get(charBegin - searchStep);
                            if (tokBegin == null) {
                                tokBegin = (Integer)beginMap.get(charBegin + searchStep);
                            }
                            ++searchStep;
                        }
                        searchStep = 1;
                        Integer tokEnd = (Integer)endMap.get(charEnd);
                        while (tokEnd == null) {
                            tokEnd = (Integer)endMap.get(charEnd - searchStep);
                            if (tokEnd == null) {
                                tokEnd = (Integer)endMap.get(charEnd + searchStep);
                            }
                            ++searchStep;
                        }
                        timexMap.set(CoreAnnotations.TokenBeginAnnotation.class, tokBegin);
                        timexMap.set(CoreAnnotations.TokenEndAnnotation.class, tokEnd);
                    }
                    timexMaps.add(timexMap);
                    continue;
                }
                throw new RuntimeException("unexpected element " + child);
            }
            throw new RuntimeException("unexpected content " + content);
        }
        return timexMaps;
    }

    @Override
    public Set<Annotator.Requirement> requires() {
        return TOKENIZE_AND_SSPLIT;
    }

    @Override
    public Set<Annotator.Requirement> requirementsSatisfied() {
        return Collections.singleton(GUTIME_REQUIREMENT);
    }
}

