/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ec;

import java.math.BigInteger;
import java.security.ProviderException;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.EllipticCurve;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import sun.security.action.GetPropertyAction;
import sun.security.ec.point.AffinePoint;
import sun.security.ec.point.MutablePoint;
import sun.security.ec.point.Point;
import sun.security.ec.point.ProjectivePoint;
import sun.security.util.math.ImmutableIntegerModuloP;
import sun.security.util.math.IntegerFieldModuloP;
import sun.security.util.math.IntegerModuloP;
import sun.security.util.math.MutableIntegerModuloP;
import sun.security.util.math.SmallValue;
import sun.security.util.math.intpoly.IntegerPolynomialP256;
import sun.security.util.math.intpoly.IntegerPolynomialP384;
import sun.security.util.math.intpoly.IntegerPolynomialP521;
import sun.security.util.math.intpoly.P256OrderField;
import sun.security.util.math.intpoly.P384OrderField;
import sun.security.util.math.intpoly.P521OrderField;

public class ECOperations {
    static final Map<BigInteger, IntegerFieldModuloP> fields = new HashMap<BigInteger, IntegerFieldModuloP>();
    static final Map<BigInteger, IntegerFieldModuloP> orderFields;
    private static boolean useLegacyECC;
    final ImmutableIntegerModuloP b;
    final SmallValue one;
    final SmallValue two;
    final SmallValue three;
    final SmallValue four;
    final ProjectivePoint.Immutable neutral;
    private final IntegerFieldModuloP orderField;

    public static Optional<ECOperations> forParameters(ECParameterSpec eCParameterSpec) {
        if (useLegacyECC) {
            return Optional.empty();
        }
        EllipticCurve ellipticCurve = eCParameterSpec.getCurve();
        if (!(ellipticCurve.getField() instanceof ECFieldFp)) {
            return Optional.empty();
        }
        ECFieldFp eCFieldFp = (ECFieldFp)ellipticCurve.getField();
        BigInteger bigInteger = BigInteger.valueOf(3L);
        if (!eCFieldFp.getP().subtract(ellipticCurve.getA()).equals(bigInteger)) {
            return Optional.empty();
        }
        IntegerFieldModuloP integerFieldModuloP = fields.get(eCFieldFp.getP());
        if (integerFieldModuloP == null) {
            return Optional.empty();
        }
        IntegerFieldModuloP integerFieldModuloP2 = orderFields.get(eCParameterSpec.getOrder());
        if (integerFieldModuloP2 == null) {
            return Optional.empty();
        }
        ImmutableIntegerModuloP immutableIntegerModuloP = integerFieldModuloP.getElement(ellipticCurve.getB());
        ECOperations eCOperations = new ECOperations(immutableIntegerModuloP, integerFieldModuloP2);
        return Optional.of(eCOperations);
    }

    public ECOperations(IntegerModuloP integerModuloP, IntegerFieldModuloP integerFieldModuloP) {
        this.b = integerModuloP.fixed();
        this.orderField = integerFieldModuloP;
        this.one = integerModuloP.getField().getSmallValue(1);
        this.two = integerModuloP.getField().getSmallValue(2);
        this.three = integerModuloP.getField().getSmallValue(3);
        this.four = integerModuloP.getField().getSmallValue(4);
        IntegerFieldModuloP integerFieldModuloP2 = integerModuloP.getField();
        this.neutral = new ProjectivePoint.Immutable(integerFieldModuloP2.get0(), integerFieldModuloP2.get1(), integerFieldModuloP2.get0());
    }

    public IntegerFieldModuloP getField() {
        return this.b.getField();
    }

    public IntegerFieldModuloP getOrderField() {
        return this.orderField;
    }

    protected ProjectivePoint.Immutable getNeutral() {
        return this.neutral;
    }

    public boolean isNeutral(Point point) {
        ProjectivePoint projectivePoint = (ProjectivePoint)point;
        Object t = projectivePoint.getZ();
        IntegerFieldModuloP integerFieldModuloP = t.getField();
        int n = (integerFieldModuloP.getSize().bitLength() + 7) / 8;
        byte[] byArray = t.asByteArray(n);
        return ECOperations.allZero(byArray);
    }

    byte[] seedToScalar(byte[] byArray) throws IntermediateValueException {
        int n;
        int n2 = this.orderField.getSize().bitLength() + 64;
        if (byArray.length * 8 < n2) {
            throw new ProviderException("Incorrect seed length: " + byArray.length * 8 + " < " + n2);
        }
        int n3 = n2 % 8;
        if (n3 != 0) {
            n = n2 / 8;
            byte by = (byte)(255 >>> 8 - n3);
            int n4 = n;
            byArray[n4] = (byte)(byArray[n4] & by);
        }
        n = (n2 + 7) / 8;
        ImmutableIntegerModuloP immutableIntegerModuloP = this.orderField.getElement(byArray, 0, n, (byte)0);
        int n5 = (this.orderField.getSize().bitLength() + 7) / 8;
        byte[] byArray2 = new byte[n5];
        immutableIntegerModuloP.asByteArray(byArray2);
        if (ECOperations.allZero(byArray2)) {
            throw new IntermediateValueException();
        }
        return byArray2;
    }

    public static boolean allZero(byte[] byArray) {
        byte by = 0;
        for (int i = 0; i < byArray.length; ++i) {
            by = (byte)(by | byArray[i]);
        }
        return by == 0;
    }

    private void lookup4(ProjectivePoint.Immutable[] immutableArray, int n, ProjectivePoint.Mutable mutable, IntegerModuloP integerModuloP) {
        for (int i = 0; i < 16; ++i) {
            int n2 = n ^ i;
            int n3 = (n2 & 8) >>> 3;
            int n4 = (n2 & 4) >>> 2;
            int n5 = (n2 & 2) >>> 1;
            int n6 = n2 & 1;
            int n7 = n6 | n5 | n4 | n3;
            int n8 = 1 - n7;
            ProjectivePoint.Immutable immutable = immutableArray[i];
            mutable.conditionalSet((Point)immutable, n8);
        }
    }

    private void double4(ProjectivePoint.Mutable mutable, MutableIntegerModuloP mutableIntegerModuloP, MutableIntegerModuloP mutableIntegerModuloP2, MutableIntegerModuloP mutableIntegerModuloP3, MutableIntegerModuloP mutableIntegerModuloP4, MutableIntegerModuloP mutableIntegerModuloP5) {
        for (int i = 0; i < 4; ++i) {
            this.setDouble(mutable, mutableIntegerModuloP, mutableIntegerModuloP2, mutableIntegerModuloP3, mutableIntegerModuloP4, mutableIntegerModuloP5);
        }
    }

    public MutablePoint multiply(AffinePoint affinePoint, byte[] byArray) {
        IntegerFieldModuloP integerFieldModuloP = affinePoint.getX().getField();
        ImmutableIntegerModuloP immutableIntegerModuloP = integerFieldModuloP.get0();
        MutableIntegerModuloP mutableIntegerModuloP = immutableIntegerModuloP.mutable();
        MutableIntegerModuloP mutableIntegerModuloP2 = immutableIntegerModuloP.mutable();
        MutableIntegerModuloP mutableIntegerModuloP3 = immutableIntegerModuloP.mutable();
        MutableIntegerModuloP mutableIntegerModuloP4 = immutableIntegerModuloP.mutable();
        MutableIntegerModuloP mutableIntegerModuloP5 = immutableIntegerModuloP.mutable();
        ProjectivePoint.Mutable mutable = new ProjectivePoint.Mutable(integerFieldModuloP);
        ((MutableIntegerModuloP)mutable.getY()).setValue(integerFieldModuloP.get1().mutable());
        ProjectivePoint.Immutable[] immutableArray = new ProjectivePoint.Immutable[16];
        immutableArray[0] = mutable.fixed();
        ProjectivePoint.Mutable mutable2 = new ProjectivePoint.Mutable(integerFieldModuloP);
        mutable2.setValue(affinePoint);
        immutableArray[1] = mutable2.fixed();
        for (int i = 2; i < 16; ++i) {
            this.setSum(mutable2, affinePoint, mutableIntegerModuloP, mutableIntegerModuloP2, mutableIntegerModuloP3, mutableIntegerModuloP4, mutableIntegerModuloP5);
            immutableArray[i] = mutable2.fixed();
        }
        MutablePoint mutablePoint = mutable2.mutable();
        for (int i = byArray.length - 1; i >= 0; --i) {
            this.double4(mutable, mutableIntegerModuloP, mutableIntegerModuloP2, mutableIntegerModuloP3, mutableIntegerModuloP4, mutableIntegerModuloP5);
            int n = (0xFF & byArray[i]) >>> 4;
            this.lookup4(immutableArray, n, (ProjectivePoint.Mutable)mutablePoint, immutableIntegerModuloP);
            this.setSum(mutable, (ProjectivePoint.Mutable)mutablePoint, mutableIntegerModuloP, mutableIntegerModuloP2, mutableIntegerModuloP3, mutableIntegerModuloP4, mutableIntegerModuloP5);
            this.double4(mutable, mutableIntegerModuloP, mutableIntegerModuloP2, mutableIntegerModuloP3, mutableIntegerModuloP4, mutableIntegerModuloP5);
            int n2 = 0xF & byArray[i];
            this.lookup4(immutableArray, n2, (ProjectivePoint.Mutable)mutablePoint, immutableIntegerModuloP);
            this.setSum(mutable, (ProjectivePoint.Mutable)mutablePoint, mutableIntegerModuloP, mutableIntegerModuloP2, mutableIntegerModuloP3, mutableIntegerModuloP4, mutableIntegerModuloP5);
        }
        return mutable;
    }

    private void setDouble(ProjectivePoint.Mutable mutable, MutableIntegerModuloP mutableIntegerModuloP, MutableIntegerModuloP mutableIntegerModuloP2, MutableIntegerModuloP mutableIntegerModuloP3, MutableIntegerModuloP mutableIntegerModuloP4, MutableIntegerModuloP mutableIntegerModuloP5) {
        mutableIntegerModuloP.setValue((IntegerModuloP)mutable.getX()).setSquare();
        mutableIntegerModuloP2.setValue((IntegerModuloP)mutable.getY()).setSquare();
        mutableIntegerModuloP3.setValue((IntegerModuloP)mutable.getZ()).setSquare();
        mutableIntegerModuloP4.setValue((IntegerModuloP)mutable.getX()).setProduct((IntegerModuloP)mutable.getY());
        mutableIntegerModuloP5.setValue((IntegerModuloP)mutable.getY()).setProduct((IntegerModuloP)mutable.getZ());
        mutableIntegerModuloP4.setSum(mutableIntegerModuloP4);
        ((MutableIntegerModuloP)mutable.getZ()).setProduct((IntegerModuloP)mutable.getX());
        ((MutableIntegerModuloP)mutable.getZ()).setProduct(this.two);
        ((MutableIntegerModuloP)mutable.getY()).setValue(mutableIntegerModuloP3).setProduct(this.b);
        ((MutableIntegerModuloP)mutable.getY()).setDifference((IntegerModuloP)mutable.getZ());
        ((MutableIntegerModuloP)mutable.getX()).setValue((IntegerModuloP)mutable.getY()).setProduct(this.two);
        ((MutableIntegerModuloP)mutable.getY()).setSum((IntegerModuloP)mutable.getX());
        ((MutableIntegerModuloP)mutable.getY()).setReduced();
        ((MutableIntegerModuloP)mutable.getX()).setValue(mutableIntegerModuloP2).setDifference((IntegerModuloP)mutable.getY());
        ((MutableIntegerModuloP)mutable.getY()).setSum(mutableIntegerModuloP2);
        ((MutableIntegerModuloP)mutable.getY()).setProduct((IntegerModuloP)mutable.getX());
        ((MutableIntegerModuloP)mutable.getX()).setProduct(mutableIntegerModuloP4);
        mutableIntegerModuloP4.setValue(mutableIntegerModuloP3).setProduct(this.two);
        mutableIntegerModuloP3.setSum(mutableIntegerModuloP4);
        ((MutableIntegerModuloP)mutable.getZ()).setProduct(this.b);
        mutableIntegerModuloP3.setReduced();
        ((MutableIntegerModuloP)mutable.getZ()).setDifference(mutableIntegerModuloP3);
        ((MutableIntegerModuloP)mutable.getZ()).setDifference(mutableIntegerModuloP);
        mutableIntegerModuloP4.setValue((IntegerModuloP)mutable.getZ()).setProduct(this.two);
        ((MutableIntegerModuloP)mutable.getZ()).setReduced();
        ((MutableIntegerModuloP)mutable.getZ()).setSum(mutableIntegerModuloP4);
        mutableIntegerModuloP.setProduct(this.three);
        mutableIntegerModuloP.setDifference(mutableIntegerModuloP3);
        mutableIntegerModuloP.setProduct((IntegerModuloP)mutable.getZ());
        ((MutableIntegerModuloP)mutable.getY()).setSum(mutableIntegerModuloP);
        mutableIntegerModuloP5.setSum(mutableIntegerModuloP5);
        ((MutableIntegerModuloP)mutable.getZ()).setProduct(mutableIntegerModuloP5);
        ((MutableIntegerModuloP)mutable.getX()).setDifference((IntegerModuloP)mutable.getZ());
        ((MutableIntegerModuloP)mutable.getZ()).setValue(mutableIntegerModuloP5).setProduct(mutableIntegerModuloP2);
        ((MutableIntegerModuloP)mutable.getZ()).setProduct(this.four);
    }

    public void setSum(MutablePoint mutablePoint, AffinePoint affinePoint) {
        ImmutableIntegerModuloP immutableIntegerModuloP = mutablePoint.getField().get0();
        MutableIntegerModuloP mutableIntegerModuloP = immutableIntegerModuloP.mutable();
        MutableIntegerModuloP mutableIntegerModuloP2 = immutableIntegerModuloP.mutable();
        MutableIntegerModuloP mutableIntegerModuloP3 = immutableIntegerModuloP.mutable();
        MutableIntegerModuloP mutableIntegerModuloP4 = immutableIntegerModuloP.mutable();
        MutableIntegerModuloP mutableIntegerModuloP5 = immutableIntegerModuloP.mutable();
        this.setSum((ProjectivePoint.Mutable)mutablePoint, affinePoint, mutableIntegerModuloP, mutableIntegerModuloP2, mutableIntegerModuloP3, mutableIntegerModuloP4, mutableIntegerModuloP5);
    }

    private void setSum(ProjectivePoint.Mutable mutable, AffinePoint affinePoint, MutableIntegerModuloP mutableIntegerModuloP, MutableIntegerModuloP mutableIntegerModuloP2, MutableIntegerModuloP mutableIntegerModuloP3, MutableIntegerModuloP mutableIntegerModuloP4, MutableIntegerModuloP mutableIntegerModuloP5) {
        mutableIntegerModuloP.setValue((IntegerModuloP)mutable.getX()).setProduct(affinePoint.getX());
        mutableIntegerModuloP2.setValue((IntegerModuloP)mutable.getY()).setProduct(affinePoint.getY());
        mutableIntegerModuloP4.setValue(affinePoint.getX()).setSum(affinePoint.getY());
        mutableIntegerModuloP5.setValue((IntegerModuloP)mutable.getX()).setSum((IntegerModuloP)mutable.getY());
        ((MutableIntegerModuloP)mutable.getX()).setReduced();
        mutableIntegerModuloP4.setProduct(mutableIntegerModuloP5);
        mutableIntegerModuloP5.setValue(mutableIntegerModuloP).setSum(mutableIntegerModuloP2);
        mutableIntegerModuloP4.setDifference(mutableIntegerModuloP5);
        mutableIntegerModuloP5.setValue(affinePoint.getY()).setProduct((IntegerModuloP)mutable.getZ());
        mutableIntegerModuloP5.setSum((IntegerModuloP)mutable.getY());
        ((MutableIntegerModuloP)mutable.getY()).setValue(affinePoint.getX()).setProduct((IntegerModuloP)mutable.getZ());
        ((MutableIntegerModuloP)mutable.getY()).setSum((IntegerModuloP)mutable.getX());
        mutableIntegerModuloP3.setValue((IntegerModuloP)mutable.getZ());
        ((MutableIntegerModuloP)mutable.getZ()).setProduct(this.b);
        ((MutableIntegerModuloP)mutable.getX()).setValue((IntegerModuloP)mutable.getY()).setDifference((IntegerModuloP)mutable.getZ());
        ((MutableIntegerModuloP)mutable.getX()).setReduced();
        ((MutableIntegerModuloP)mutable.getZ()).setValue((IntegerModuloP)mutable.getX()).setProduct(this.two);
        ((MutableIntegerModuloP)mutable.getX()).setSum((IntegerModuloP)mutable.getZ());
        ((MutableIntegerModuloP)mutable.getZ()).setValue(mutableIntegerModuloP2).setDifference((IntegerModuloP)mutable.getX());
        ((MutableIntegerModuloP)mutable.getX()).setSum(mutableIntegerModuloP2);
        ((MutableIntegerModuloP)mutable.getY()).setProduct(this.b);
        mutableIntegerModuloP2.setValue(mutableIntegerModuloP3).setProduct(this.two);
        mutableIntegerModuloP3.setSum(mutableIntegerModuloP2);
        mutableIntegerModuloP3.setReduced();
        ((MutableIntegerModuloP)mutable.getY()).setDifference(mutableIntegerModuloP3);
        ((MutableIntegerModuloP)mutable.getY()).setDifference(mutableIntegerModuloP);
        ((MutableIntegerModuloP)mutable.getY()).setReduced();
        mutableIntegerModuloP2.setValue((IntegerModuloP)mutable.getY()).setProduct(this.two);
        ((MutableIntegerModuloP)mutable.getY()).setSum(mutableIntegerModuloP2);
        mutableIntegerModuloP2.setValue(mutableIntegerModuloP).setProduct(this.two);
        mutableIntegerModuloP.setSum(mutableIntegerModuloP2);
        mutableIntegerModuloP.setDifference(mutableIntegerModuloP3);
        mutableIntegerModuloP2.setValue(mutableIntegerModuloP5).setProduct((IntegerModuloP)mutable.getY());
        mutableIntegerModuloP3.setValue(mutableIntegerModuloP).setProduct((IntegerModuloP)mutable.getY());
        ((MutableIntegerModuloP)mutable.getY()).setValue((IntegerModuloP)mutable.getX()).setProduct((IntegerModuloP)mutable.getZ());
        ((MutableIntegerModuloP)mutable.getY()).setSum(mutableIntegerModuloP3);
        ((MutableIntegerModuloP)mutable.getX()).setProduct(mutableIntegerModuloP4);
        ((MutableIntegerModuloP)mutable.getX()).setDifference(mutableIntegerModuloP2);
        ((MutableIntegerModuloP)mutable.getZ()).setProduct(mutableIntegerModuloP5);
        mutableIntegerModuloP2.setValue(mutableIntegerModuloP4).setProduct(mutableIntegerModuloP);
        ((MutableIntegerModuloP)mutable.getZ()).setSum(mutableIntegerModuloP2);
    }

    private void setSum(ProjectivePoint.Mutable mutable, ProjectivePoint.Mutable mutable2, MutableIntegerModuloP mutableIntegerModuloP, MutableIntegerModuloP mutableIntegerModuloP2, MutableIntegerModuloP mutableIntegerModuloP3, MutableIntegerModuloP mutableIntegerModuloP4, MutableIntegerModuloP mutableIntegerModuloP5) {
        mutableIntegerModuloP.setValue((IntegerModuloP)mutable.getX()).setProduct((IntegerModuloP)mutable2.getX());
        mutableIntegerModuloP2.setValue((IntegerModuloP)mutable.getY()).setProduct((IntegerModuloP)mutable2.getY());
        mutableIntegerModuloP3.setValue((IntegerModuloP)mutable.getZ()).setProduct((IntegerModuloP)mutable2.getZ());
        mutableIntegerModuloP4.setValue((IntegerModuloP)mutable.getX()).setSum((IntegerModuloP)mutable.getY());
        mutableIntegerModuloP5.setValue((IntegerModuloP)mutable2.getX()).setSum((IntegerModuloP)mutable2.getY());
        mutableIntegerModuloP4.setProduct(mutableIntegerModuloP5);
        mutableIntegerModuloP5.setValue(mutableIntegerModuloP).setSum(mutableIntegerModuloP2);
        mutableIntegerModuloP4.setDifference(mutableIntegerModuloP5);
        mutableIntegerModuloP5.setValue((IntegerModuloP)mutable.getY()).setSum((IntegerModuloP)mutable.getZ());
        ((MutableIntegerModuloP)mutable.getY()).setValue((IntegerModuloP)mutable2.getY()).setSum((IntegerModuloP)mutable2.getZ());
        mutableIntegerModuloP5.setProduct((IntegerModuloP)mutable.getY());
        ((MutableIntegerModuloP)mutable.getY()).setValue(mutableIntegerModuloP2).setSum(mutableIntegerModuloP3);
        mutableIntegerModuloP5.setDifference((IntegerModuloP)mutable.getY());
        ((MutableIntegerModuloP)mutable.getX()).setSum((IntegerModuloP)mutable.getZ());
        ((MutableIntegerModuloP)mutable.getY()).setValue((IntegerModuloP)mutable2.getX()).setSum((IntegerModuloP)mutable2.getZ());
        ((MutableIntegerModuloP)mutable.getX()).setProduct((IntegerModuloP)mutable.getY());
        ((MutableIntegerModuloP)mutable.getY()).setValue(mutableIntegerModuloP).setSum(mutableIntegerModuloP3);
        ((MutableIntegerModuloP)mutable.getY()).setAdditiveInverse().setSum((IntegerModuloP)mutable.getX());
        ((MutableIntegerModuloP)mutable.getY()).setReduced();
        ((MutableIntegerModuloP)mutable.getZ()).setValue(mutableIntegerModuloP3).setProduct(this.b);
        ((MutableIntegerModuloP)mutable.getX()).setValue((IntegerModuloP)mutable.getY()).setDifference((IntegerModuloP)mutable.getZ());
        ((MutableIntegerModuloP)mutable.getZ()).setValue((IntegerModuloP)mutable.getX()).setProduct(this.two);
        ((MutableIntegerModuloP)mutable.getX()).setSum((IntegerModuloP)mutable.getZ());
        ((MutableIntegerModuloP)mutable.getX()).setReduced();
        ((MutableIntegerModuloP)mutable.getZ()).setValue(mutableIntegerModuloP2).setDifference((IntegerModuloP)mutable.getX());
        ((MutableIntegerModuloP)mutable.getX()).setSum(mutableIntegerModuloP2);
        ((MutableIntegerModuloP)mutable.getY()).setProduct(this.b);
        mutableIntegerModuloP2.setValue(mutableIntegerModuloP3).setSum(mutableIntegerModuloP3);
        mutableIntegerModuloP3.setSum(mutableIntegerModuloP2);
        mutableIntegerModuloP3.setReduced();
        ((MutableIntegerModuloP)mutable.getY()).setDifference(mutableIntegerModuloP3);
        ((MutableIntegerModuloP)mutable.getY()).setDifference(mutableIntegerModuloP);
        ((MutableIntegerModuloP)mutable.getY()).setReduced();
        mutableIntegerModuloP2.setValue((IntegerModuloP)mutable.getY()).setSum((IntegerModuloP)mutable.getY());
        ((MutableIntegerModuloP)mutable.getY()).setSum(mutableIntegerModuloP2);
        mutableIntegerModuloP2.setValue(mutableIntegerModuloP).setProduct(this.two);
        mutableIntegerModuloP.setSum(mutableIntegerModuloP2);
        mutableIntegerModuloP.setDifference(mutableIntegerModuloP3);
        mutableIntegerModuloP2.setValue(mutableIntegerModuloP5).setProduct((IntegerModuloP)mutable.getY());
        mutableIntegerModuloP3.setValue(mutableIntegerModuloP).setProduct((IntegerModuloP)mutable.getY());
        ((MutableIntegerModuloP)mutable.getY()).setValue((IntegerModuloP)mutable.getX()).setProduct((IntegerModuloP)mutable.getZ());
        ((MutableIntegerModuloP)mutable.getY()).setSum(mutableIntegerModuloP3);
        ((MutableIntegerModuloP)mutable.getX()).setProduct(mutableIntegerModuloP4);
        ((MutableIntegerModuloP)mutable.getX()).setDifference(mutableIntegerModuloP2);
        ((MutableIntegerModuloP)mutable.getZ()).setProduct(mutableIntegerModuloP5);
        mutableIntegerModuloP2.setValue(mutableIntegerModuloP4).setProduct(mutableIntegerModuloP);
        ((MutableIntegerModuloP)mutable.getZ()).setSum(mutableIntegerModuloP2);
    }

    static {
        fields.put(IntegerPolynomialP256.MODULUS, new IntegerPolynomialP256());
        fields.put(IntegerPolynomialP384.MODULUS, new IntegerPolynomialP384());
        fields.put(IntegerPolynomialP521.MODULUS, new IntegerPolynomialP521());
        orderFields = new HashMap<BigInteger, IntegerFieldModuloP>();
        orderFields.put(P256OrderField.MODULUS, new P256OrderField());
        orderFields.put(P384OrderField.MODULUS, new P384OrderField());
        orderFields.put(P521OrderField.MODULUS, new P521OrderField());
        String string = GetPropertyAction.privilegedGetProperty("jdk.security.useLegacyECC", "false");
        useLegacyECC = "".equals(string) || Boolean.parseBoolean(string);
    }

    static class IntermediateValueException
    extends Exception {
        private static final long serialVersionUID = 1L;

        IntermediateValueException() {
        }
    }
}

