/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.hcoref.md;

import edu.stanford.nlp.hcoref.CorefProperties;
import edu.stanford.nlp.hcoref.data.Dictionaries;
import edu.stanford.nlp.hcoref.data.Mention;
import edu.stanford.nlp.hcoref.md.CorefMentionFinder;
import edu.stanford.nlp.hcoref.md.HybridCorefMentionFinder;
import edu.stanford.nlp.hcoref.md.MentionDetectionClassifier;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.semgraph.SemanticGraphEdge;
import edu.stanford.nlp.semgraph.SemanticGraphUtils;
import edu.stanford.nlp.trees.EnglishGrammaticalRelations;
import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.IntPair;
import edu.stanford.nlp.util.Pair;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;

public class DependencyCorefMentionFinder
extends CorefMentionFinder {
    public MentionDetectionClassifier mdClassifier = null;

    public DependencyCorefMentionFinder(Properties props) throws ClassNotFoundException, IOException {
        this.lang = CorefProperties.getLanguage(props);
        this.mdClassifier = CorefProperties.isMentionDetectionTraining(props) ? null : (MentionDetectionClassifier)IOUtils.readObjectFromURLOrClasspathOrFileSystem(CorefProperties.getMentionDetectionModel(props));
    }

    @Override
    public List<List<Mention>> findMentions(Annotation doc, Dictionaries dict, Properties props) {
        ArrayList<List<Mention>> predictedMentions = new ArrayList<List<Mention>>();
        Set<String> neStrings = Generics.newHashSet();
        ArrayList<Set<IntPair>> mentionSpanSetList = Generics.newArrayList();
        List sentences = (List)doc.get(CoreAnnotations.SentencesAnnotation.class);
        for (CoreMap s : sentences) {
            ArrayList<Mention> mentions = new ArrayList<Mention>();
            predictedMentions.add(mentions);
            Set<IntPair> mentionSpanSet = Generics.newHashSet();
            Set<IntPair> namedEntitySpanSet = Generics.newHashSet();
            DependencyCorefMentionFinder.extractPremarkedEntityMentions(s, mentions, mentionSpanSet, namedEntitySpanSet);
            HybridCorefMentionFinder.extractNamedEntityMentions(s, mentions, mentionSpanSet, namedEntitySpanSet);
            this.extractNPorPRPFromDependency(s, mentions, mentionSpanSet, namedEntitySpanSet);
            DependencyCorefMentionFinder.addNamedEntityStrings(s, neStrings, namedEntitySpanSet);
            mentionSpanSetList.add(mentionSpanSet);
        }
        for (int i = 0; i < sentences.size(); ++i) {
            this.findHead((CoreMap)sentences.get(i), (List)predictedMentions.get(i));
        }
        this.removeSpuriousMentions(doc, predictedMentions, dict, CorefProperties.removeNested(props), this.lang);
        if (!CorefProperties.isMentionDetectionTraining(props)) {
            this.mdClassifier.classifyMentions(predictedMentions, dict, props);
        }
        return predictedMentions;
    }

    protected static void assignMentionIDs(List<List<Mention>> predictedMentions, int maxID) {
        for (List<Mention> mentions : predictedMentions) {
            for (Mention m : mentions) {
                m.mentionID = ++maxID;
            }
        }
    }

    protected static void setBarePlural(List<Mention> mentions) {
        for (Mention m : mentions) {
            String pos = (String)m.headWord.get(CoreAnnotations.PartOfSpeechAnnotation.class);
            if (m.originalSpan.size() != 1 || !pos.equals("NNS")) continue;
            m.generic = true;
        }
    }

    private void extractNPorPRPFromDependency(CoreMap s, List<Mention> mentions, Set<IntPair> mentionSpanSet, Set<IntPair> namedEntitySpanSet) {
        List sent = (List)s.get(CoreAnnotations.TokensAnnotation.class);
        SemanticGraph basic = (SemanticGraph)s.get(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class);
        List<IndexedWord> nounsOrPrp = basic.getAllNodesByPartOfSpeechPattern("N.*|PRP.*|DT");
        Tree tree = (Tree)s.get(TreeCoreAnnotations.TreeAnnotation.class);
        for (IndexedWord w : nounsOrPrp) {
            SemanticGraphEdge edge = basic.getEdge(basic.getParent(w), w);
            GrammaticalRelation rel = null;
            String shortname = "root";
            if (edge != null) {
                rel = edge.getRelation();
                shortname = rel.getShortName();
            }
            if (shortname.matches("det|nn")) continue;
            this.extractMentionForHeadword(w, basic, s, mentions, mentionSpanSet, namedEntitySpanSet);
        }
    }

    private void extractMentionForHeadword(IndexedWord headword, SemanticGraph dep, CoreMap s, List<Mention> mentions, Set<IntPair> mentionSpanSet, Set<IntPair> namedEntitySpanSet) {
        List sent = (List)s.get(CoreAnnotations.TokensAnnotation.class);
        SemanticGraph basic = (SemanticGraph)s.get(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class);
        SemanticGraph collapsed = (SemanticGraph)s.get(SemanticGraphCoreAnnotations.CollapsedDependenciesAnnotation.class);
        if (headword.tag().startsWith("PRP")) {
            this.extractPronounForHeadword(headword, dep, s, mentions, mentionSpanSet, namedEntitySpanSet);
            return;
        }
        IntPair npSpan = this.getNPSpan(headword, dep, sent);
        int beginIdx = npSpan.get(0);
        int endIdx = npSpan.get(1) + 1;
        if (",".equals(((CoreLabel)sent.get(endIdx - 1)).word())) {
            --endIdx;
        }
        if ("IN".equals(((CoreLabel)sent.get(beginIdx)).tag())) {
            ++beginIdx;
        }
        this.addMention(beginIdx, endIdx, headword, mentions, mentionSpanSet, namedEntitySpanSet, sent, basic, collapsed);
        Set<IndexedWord> conjChildren = dep.getChildrenWithReln(headword, EnglishGrammaticalRelations.CONJUNCT);
        if (conjChildren.size() > 0) {
            IndexedWord conjChild = dep.getChildWithReln(headword, EnglishGrammaticalRelations.CONJUNCT);
            for (IndexedWord c : conjChildren) {
                if (c.index() >= conjChild.index()) continue;
                conjChild = c;
            }
            IndexedWord left = SemanticGraphUtils.leftMostChildVertice(conjChild, dep);
            for (int endIdxFirstElement = left.index() - 1; endIdxFirstElement > beginIdx; --endIdxFirstElement) {
                if (((CoreLabel)sent.get(endIdxFirstElement - 1)).tag().matches("CC|,")) continue;
                if (headword.index() - 1 >= endIdxFirstElement) break;
                this.addMention(beginIdx, endIdxFirstElement, headword, mentions, mentionSpanSet, namedEntitySpanSet, sent, basic, collapsed);
                break;
            }
        }
    }

    private IntPair getNPSpan(IndexedWord headword, SemanticGraph dep, List<CoreLabel> sent) {
        int headwordIdx = headword.index() - 1;
        List<IndexedWord> children = dep.getChildList(headword);
        IndexedWord cop = dep.getChildWithReln(headword, EnglishGrammaticalRelations.COPULA);
        int startIdx = cop == null ? 0 : children.indexOf(cop) + 1;
        ArrayList<IndexedWord> insideNP = Generics.newArrayList();
        for (int i = startIdx; i < children.size(); ++i) {
            IndexedWord child = children.get(i);
            SemanticGraphEdge edge = dep.getEdge(headword, child);
            if (edge.getRelation().getShortName().matches("dep|discourse|punct")) continue;
            insideNP.add(child);
        }
        if (insideNP.size() == 0) {
            return new IntPair(headwordIdx, headwordIdx);
        }
        Pair<IndexedWord, IndexedWord> firstChildLeftRight = SemanticGraphUtils.leftRightMostChildVertices((IndexedWord)insideNP.get(0), dep);
        Pair<IndexedWord, IndexedWord> lastChildLeftRight = SemanticGraphUtils.leftRightMostChildVertices((IndexedWord)insideNP.get(insideNP.size() - 1), dep);
        int beginIdx = Math.min(headwordIdx, ((IndexedWord)firstChildLeftRight.first).index() - 1);
        int endIdx = Math.max(headwordIdx, ((IndexedWord)lastChildLeftRight.second).index() - 1);
        return new IntPair(beginIdx, endIdx);
    }

    private IntPair getNPSpanOld(IndexedWord headword, SemanticGraph dep, List<CoreLabel> sent) {
        IndexedWord cop = dep.getChildWithReln(headword, EnglishGrammaticalRelations.COPULA);
        Pair<IndexedWord, IndexedWord> leftRight = SemanticGraphUtils.leftRightMostChildVertices(headword, dep);
        int beginIdx = Math.min(headword.index() - 1, ((IndexedWord)leftRight.first).index() - 1);
        int endIdx = Math.max(headword.index() - 1, ((IndexedWord)leftRight.second).index() - 1);
        if (cop == null) {
            return new IntPair(beginIdx, endIdx);
        }
        List<IndexedWord> children = dep.getChildList(headword);
        int copIdx = children.indexOf(cop);
        beginIdx = copIdx + 1 < children.size() ? Math.min(headword.index() - 1, SemanticGraphUtils.leftMostChildVertice(children.get(copIdx + 1), dep).index() - 1) : headword.index() - 1;
        return new IntPair(beginIdx, endIdx);
    }

    private void addMention(int beginIdx, int endIdx, IndexedWord headword, List<Mention> mentions, Set<IntPair> mentionSpanSet, Set<IntPair> namedEntitySpanSet, List<CoreLabel> sent, SemanticGraph basic, SemanticGraph collapsed) {
        IntPair mSpan = new IntPair(beginIdx, endIdx);
        if (!mentionSpanSet.contains(mSpan) && !DependencyCorefMentionFinder.insideNE(mSpan, namedEntitySpanSet)) {
            int dummyMentionId = -1;
            Mention m = new Mention(dummyMentionId, beginIdx, endIdx, sent, basic, collapsed, new ArrayList<CoreLabel>(sent.subList(beginIdx, endIdx)));
            m.headIndex = headword.index() - 1;
            m.headWord = sent.get(m.headIndex);
            m.headString = m.headWord.word().toLowerCase(Locale.ENGLISH);
            mentions.add(m);
            mentionSpanSet.add(mSpan);
        }
    }

    private void extractPronounForHeadword(IndexedWord headword, SemanticGraph dep, CoreMap s, List<Mention> mentions, Set<IntPair> mentionSpanSet, Set<IntPair> namedEntitySpanSet) {
        Set<IndexedWord> conjChildren;
        IntPair mSpan;
        IndexedWord c;
        SemanticGraphEdge edge;
        List sent = (List)s.get(CoreAnnotations.TokensAnnotation.class);
        SemanticGraph basic = (SemanticGraph)s.get(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class);
        SemanticGraph collapsed = (SemanticGraph)s.get(SemanticGraphCoreAnnotations.CollapsedDependenciesAnnotation.class);
        int beginIdx = headword.index() - 1;
        int endIdx = headword.index();
        if (sent.size() > headword.index() && ((CoreLabel)sent.get(headword.index())).word().matches("all|both") && (edge = dep.getEdge(headword, c = dep.getNodeByIndex(headword.index() + 1))) != null) {
            ++endIdx;
        }
        if (!mentionSpanSet.contains(mSpan = new IntPair(beginIdx, endIdx)) && !DependencyCorefMentionFinder.insideNE(mSpan, namedEntitySpanSet)) {
            int dummyMentionId = -1;
            Mention m = new Mention(dummyMentionId, beginIdx, endIdx, sent, basic, collapsed, new ArrayList<CoreLabel>(sent.subList(beginIdx, endIdx)));
            m.headIndex = headword.index() - 1;
            m.headWord = (CoreLabel)sent.get(m.headIndex);
            m.headString = m.headWord.word().toLowerCase(Locale.ENGLISH);
            mentions.add(m);
            mentionSpanSet.add(mSpan);
        }
        if ((conjChildren = dep.getChildrenWithReln(headword, EnglishGrammaticalRelations.CONJUNCT)).size() > 0) {
            IntPair npSpan = this.getNPSpan(headword, dep, sent);
            beginIdx = npSpan.get(0);
            endIdx = npSpan.get(1) + 1;
            if (",".equals(((CoreLabel)sent.get(endIdx - 1)).word())) {
                --endIdx;
            }
            this.addMention(beginIdx, endIdx, headword, mentions, mentionSpanSet, namedEntitySpanSet, sent, basic, collapsed);
        }
    }

    public static void findHeadInDependency(CoreMap s, List<Mention> mentions) {
        for (Mention m : mentions) {
            DependencyCorefMentionFinder.findHeadInDependency(s, m);
        }
    }

    @Override
    public void findHead(CoreMap s, List<Mention> mentions) {
        for (Mention m : mentions) {
            DependencyCorefMentionFinder.findHeadInDependency(s, m);
        }
    }

    public static void findHeadInDependency(CoreMap s, Mention m) {
        List sent = (List)s.get(CoreAnnotations.TokensAnnotation.class);
        SemanticGraph basicDep = (SemanticGraph)s.get(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class);
        if (m.headWord == null) {
            IndexedWord p;
            int curIdx;
            IndexedWord cur = null;
            for (curIdx = m.endIndex - 1; curIdx >= m.startIndex && (cur = basicDep.getNodeByIndexSafe(curIdx + 1)) == null; --curIdx) {
            }
            if (cur == null) {
                curIdx = m.endIndex - 1;
            }
            while (cur != null && (p = basicDep.getParent(cur)) != null && p.index() - 1 >= m.startIndex && p.index() - 1 < m.endIndex) {
                curIdx = p.index() - 1;
                cur = basicDep.getNodeByIndexSafe(curIdx + 1);
            }
            m.headIndex = curIdx;
            m.headWord = (CoreLabel)sent.get(m.headIndex);
            m.headString = m.headWord.word().toLowerCase(Locale.ENGLISH);
        }
    }

    @Override
    public void removeSpuriousMentionsEn(Annotation doc, List<List<Mention>> predictedMentions, Dictionaries dict) {
        List sentences = (List)doc.get(CoreAnnotations.SentencesAnnotation.class);
        for (int i = 0; i < predictedMentions.size(); ++i) {
            CoreMap s = (CoreMap)sentences.get(i);
            List<Mention> mentions = predictedMentions.get(i);
            List sent = (List)s.get(CoreAnnotations.TokensAnnotation.class);
            Set<Mention> remove = Generics.newHashSet();
            for (Mention m : mentions) {
                String headPOS = (String)m.headWord.get(CoreAnnotations.PartOfSpeechAnnotation.class);
                if (dict.nonWords.contains(m.headString)) {
                    remove.add(m);
                }
                if (dict.isAdjectivalDemonym(m.spanToString()) && (!headPOS.startsWith("N") || m.endIndex < sent.size() && ((CoreLabel)sent.get(m.endIndex)).tag().startsWith("N"))) {
                    remove.add(m);
                }
                if (!DependencyCorefMentionFinder.inStopList(m)) continue;
                remove.add(m);
            }
            mentions.removeAll(remove);
        }
    }
}

