/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.crf;

import edu.stanford.nlp.ie.crf.CRFClassifier;
import edu.stanford.nlp.ie.crf.CRFDatum;
import edu.stanford.nlp.ie.crf.CRFLabel;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.objectbank.ObjectBank;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.StringUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;

public class CRFFeatureExporter<IN extends CoreMap> {
    private char delimiter = (char)9;
    private static final String eol = System.getProperty("line.separator");
    private CRFClassifier<IN> classifier;

    public CRFFeatureExporter(CRFClassifier<IN> classifier) {
        this.classifier = classifier;
    }

    private static String ubPrefixFeatureString(String feat) {
        if (feat.endsWith("|C")) {
            return "U-" + feat;
        }
        if (feat.endsWith("|CpC")) {
            return "B-" + feat;
        }
        return feat;
    }

    private String getFeatureString(List<IN> document) {
        int docSize = document.size();
        if (this.classifier.flags.useReverse) {
            Collections.reverse(document);
        }
        StringBuilder sb = new StringBuilder();
        for (int j = 0; j < docSize; ++j) {
            CoreMap token = (CoreMap)document.get(j);
            sb.append((String)token.get(CoreAnnotations.TextAnnotation.class));
            sb.append(this.delimiter);
            sb.append((String)token.get(CoreAnnotations.AnswerAnnotation.class));
            CRFDatum<List<String>, CRFLabel> d = this.classifier.makeDatum(document, j, this.classifier.featureFactories);
            List<List<String>> features = d.asFeatures();
            for (Collection collection : features) {
                ArrayList sortedFeatures = new ArrayList(collection);
                Collections.sort(sortedFeatures);
                for (String feat : sortedFeatures) {
                    feat = CRFFeatureExporter.ubPrefixFeatureString(feat);
                    sb.append(this.delimiter);
                    sb.append(feat);
                }
            }
            sb.append(eol);
        }
        if (this.classifier.flags.useReverse) {
            Collections.reverse(document);
        }
        return sb.toString();
    }

    public void printFeatures(String exportFile, int[][][][] docsData, int[][] labels) {
        try {
            PrintWriter pw = IOUtils.getPrintWriter(exportFile);
            for (int i = 0; i < docsData.length; ++i) {
                for (int j = 0; j < docsData[i].length; ++j) {
                    StringBuilder sb = new StringBuilder();
                    int label = labels[i][j];
                    sb.append((String)this.classifier.classIndex.get(label));
                    for (int k = 0; k < docsData[i][j].length; ++k) {
                        for (int m = 0; m < docsData[i][j][k].length; ++m) {
                            String feat = this.classifier.featureIndex.get(docsData[i][j][k][m]);
                            feat = CRFFeatureExporter.ubPrefixFeatureString(feat);
                            sb.append(this.delimiter);
                            sb.append(feat);
                        }
                    }
                    pw.println(sb.toString());
                }
                pw.println();
            }
            pw.close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void printFeatures(String exportFile, Collection<List<IN>> documents) {
        try {
            PrintWriter pw = IOUtils.getPrintWriter(exportFile);
            for (List<IN> doc : documents) {
                String str = this.getFeatureString(doc);
                pw.println(str);
            }
            pw.close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void main(String[] args) throws Exception {
        String outputFile;
        StringUtils.printErrInvocationString("CRFFeatureExporter", args);
        Properties props = StringUtils.argsToProperties(args);
        CRFClassifier crf = new CRFClassifier(props);
        String inputFile = crf.flags.trainFile;
        if (inputFile == null) {
            System.err.println("Please provide input file using -trainFile");
            System.exit(-1);
        }
        if ((outputFile = crf.flags.exportFeatures) == null) {
            System.err.println("Please provide output file using -exportFeatures");
            System.exit(-1);
        }
        CRFFeatureExporter featureExporter = new CRFFeatureExporter(crf);
        ObjectBank docs = crf.makeObjectBankFromFile(inputFile, crf.makeReaderAndWriter());
        crf.makeAnswerArraysAndTagIndex(docs);
        featureExporter.printFeatures(outputFile, docs);
    }
}

