/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.hcoref.CorefCoreAnnotations;
import edu.stanford.nlp.hcoref.data.CorefChain;
import edu.stanford.nlp.ie.machinereading.structure.Span;
import edu.stanford.nlp.io.StringOutputStream;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.Sentence;
import edu.stanford.nlp.naturalli.NaturalLogicAnnotations;
import edu.stanford.nlp.neural.rnn.RNNCoreAnnotations;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.AnnotationOutputter;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.sentiment.SentimentCoreAnnotations;
import edu.stanford.nlp.time.TimeAnnotations;
import edu.stanford.nlp.time.Timex;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.trees.TreePrint;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.Pointer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class JSONOutputter
extends AnnotationOutputter {
    protected static final String INDENT_CHAR = "  ";

    public static String cleanJSON(String s) {
        return s.replace("\\", "\\\\").replace("\b", "\\b").replace("\f", "\\f").replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t").replace("\"", "\\\"");
    }

    @Override
    public void print(Annotation doc, OutputStream target, AnnotationOutputter.Options options) throws IOException {
        JSONWriter l0 = new JSONWriter(new PrintWriter(target), options);
        l0.object(l1 -> {
            Map corefChains;
            l1.set("docId", doc.get(CoreAnnotations.DocIDAnnotation.class));
            l1.set("docDate", doc.get(CoreAnnotations.DocDateAnnotation.class));
            l1.set("docSourceType", doc.get(CoreAnnotations.DocSourceTypeAnnotation.class));
            l1.set("docType", doc.get(CoreAnnotations.DocTypeAnnotation.class));
            l1.set("author", doc.get(CoreAnnotations.AuthorAnnotation.class));
            l1.set("location", doc.get(CoreAnnotations.LocationAnnotation.class));
            if (options.includeText) {
                l1.set("text", doc.get(CoreAnnotations.TextAnnotation.class));
            }
            if (doc.get(CoreAnnotations.SentencesAnnotation.class) != null) {
                l1.set("sentences", ((List)doc.get(CoreAnnotations.SentencesAnnotation.class)).stream().map(sentence -> l2 -> {
                    Collection openIETriples;
                    l2.set("id", sentence.get(CoreAnnotations.SentenceIDAnnotation.class));
                    l2.set("index", sentence.get(CoreAnnotations.SentenceIndexAnnotation.class));
                    l2.set("line", sentence.get(CoreAnnotations.LineNumberAnnotation.class));
                    StringWriter treeStrWriter = new StringWriter();
                    TreePrint treePrinter = options.constituentTreePrinter;
                    if (treePrinter == AnnotationOutputter.DEFAULT_CONSTITUENT_TREE_PRINTER) {
                        treePrinter = new TreePrint("oneline");
                    }
                    treePrinter.printTree((Tree)sentence.get(TreeCoreAnnotations.TreeAnnotation.class), new PrintWriter((java.io.Writer)treeStrWriter, true));
                    l2.set("parse", treeStrWriter.toString().trim());
                    l2.set("basic-dependencies", JSONOutputter.buildDependencyTree((SemanticGraph)sentence.get(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class)));
                    l2.set("collapsed-dependencies", JSONOutputter.buildDependencyTree((SemanticGraph)sentence.get(SemanticGraphCoreAnnotations.CollapsedDependenciesAnnotation.class)));
                    l2.set("collapsed-ccprocessed-dependencies", JSONOutputter.buildDependencyTree((SemanticGraph)sentence.get(SemanticGraphCoreAnnotations.CollapsedCCProcessedDependenciesAnnotation.class)));
                    Tree sentimentTree = (Tree)sentence.get(SentimentCoreAnnotations.SentimentAnnotatedTree.class);
                    if (sentimentTree != null) {
                        int sentiment = RNNCoreAnnotations.getPredictedClass(sentimentTree);
                        String sentimentClass = (String)sentence.get(SentimentCoreAnnotations.SentimentClass.class);
                        l2.set("sentimentValue", Integer.toString(sentiment));
                        l2.set("sentiment", sentimentClass.replaceAll(" ", ""));
                    }
                    if ((openIETriples = (Collection)sentence.get(NaturalLogicAnnotations.RelationTriplesAnnotation.class)) != null) {
                        l2.set("openie", openIETriples.stream().map(triple -> tripleWriter -> {
                            tripleWriter.set("subject", triple.subjectGloss());
                            tripleWriter.set("subjectSpan", Span.fromPair(triple.subjectTokenSpan()));
                            tripleWriter.set("relation", triple.relationGloss());
                            tripleWriter.set("relationSpan", Span.fromPair(triple.relationTokenSpan()));
                            tripleWriter.set("object", triple.objectGloss());
                            tripleWriter.set("objectSpan", Span.fromPair(triple.objectTokenSpan()));
                        }));
                    }
                    if (sentence.get(CoreAnnotations.TokensAnnotation.class) != null) {
                        l2.set("tokens", ((List)sentence.get(CoreAnnotations.TokensAnnotation.class)).stream().map(token -> l3 -> {
                            l3.set("index", token.index());
                            l3.set("word", token.word());
                            l3.set("originalText", token.originalText());
                            l3.set("lemma", token.lemma());
                            l3.set("characterOffsetBegin", token.beginPosition());
                            l3.set("characterOffsetEnd", token.endPosition());
                            l3.set("pos", token.tag());
                            l3.set("ner", token.ner());
                            l3.set("normalizedNER", token.get(CoreAnnotations.NormalizedNamedEntityTagAnnotation.class));
                            l3.set("speaker", token.get(CoreAnnotations.SpeakerAnnotation.class));
                            l3.set("truecase", token.get(CoreAnnotations.TrueCaseAnnotation.class));
                            l3.set("truecaseText", token.get(CoreAnnotations.TrueCaseTextAnnotation.class));
                            l3.set("before", token.get(CoreAnnotations.BeforeAnnotation.class));
                            l3.set("after", token.get(CoreAnnotations.AfterAnnotation.class));
                            Timex time = (Timex)token.get(TimeAnnotations.TimexAnnotation.class);
                            if (time != null) {
                                l3.set("timex", l4 -> {
                                    l4.set("tid", time.tid());
                                    l4.set("type", time.timexType());
                                    l4.set("value", time.value());
                                    l4.set("altValue", time.altVal());
                                });
                            }
                        }));
                    }
                }));
            }
            if (doc.get(CorefCoreAnnotations.CorefChainAnnotation.class) != null && (corefChains = (Map)doc.get(CorefCoreAnnotations.CorefChainAnnotation.class)) != null) {
                l1.set("corefs", chainWriter -> {
                    for (CorefChain chain : corefChains.values()) {
                        CorefChain.CorefMention representative = chain.getRepresentativeMention();
                        chainWriter.set(Integer.toString(chain.getChainID()), chain.getMentionsInTextualOrder().stream().map(mention -> mentionWriter -> {
                            mentionWriter.set("id", mention.mentionID);
                            mentionWriter.set("text", Sentence.listToOriginalTextString(((List)((CoreMap)((List)doc.get(CoreAnnotations.SentencesAnnotation.class)).get(mention.sentNum - 1)).get(CoreAnnotations.TokensAnnotation.class)).subList(mention.startIndex - 1, mention.endIndex - 1)).trim());
                            mentionWriter.set("type", (Object)mention.mentionType);
                            mentionWriter.set("number", (Object)mention.number);
                            mentionWriter.set("gender", (Object)mention.gender);
                            mentionWriter.set("animacy", (Object)mention.animacy);
                            mentionWriter.set("startIndex", mention.startIndex);
                            mentionWriter.set("endIndex", mention.endIndex);
                            mentionWriter.set("sentNum", mention.sentNum);
                            mentionWriter.set("position", Arrays.stream(mention.position.elems()).boxed().collect(Collectors.toList()));
                            mentionWriter.set("isRepresentativeMention", mention == representative);
                        }));
                    }
                });
            }
        });
        l0.writer.flush();
    }

    private static Object buildDependencyTree(SemanticGraph graph) {
        if (graph != null) {
            return Stream.concat(graph.getRoots().stream().map(root -> dep -> {
                dep.set("dep", "ROOT");
                dep.set("governor", 0);
                dep.set("governorGloss", "ROOT");
                dep.set("dependent", root.index());
                dep.set("dependentGloss", root.word());
            }), graph.edgeListSorted().stream().map(edge -> dep -> {
                dep.set("dep", edge.getRelation().toString());
                dep.set("governor", edge.getGovernor().index());
                dep.set("governorGloss", edge.getGovernor().word());
                dep.set("dependent", edge.getDependent().index());
                dep.set("dependentGloss", edge.getDependent().word());
            }));
        }
        return null;
    }

    public static String jsonPrint(Annotation annotation) throws IOException {
        StringOutputStream os = new StringOutputStream();
        new JSONOutputter().print(annotation, os);
        return os.toString();
    }

    public static void jsonPrint(Annotation annotation, OutputStream os) throws IOException {
        new JSONOutputter().print(annotation, os);
    }

    public static void jsonPrint(Annotation annotation, OutputStream os, StanfordCoreNLP pipeline) throws IOException {
        new JSONOutputter().print(annotation, os, pipeline);
    }

    public static void jsonPrint(Annotation annotation, OutputStream os, AnnotationOutputter.Options options) throws IOException {
        new JSONOutputter().print(annotation, os, options);
    }

    @FunctionalInterface
    protected static interface Writer {
        public void set(String var1, Object var2);
    }

    protected static class JSONWriter {
        private final PrintWriter writer;
        private final AnnotationOutputter.Options options;

        private JSONWriter(PrintWriter writer, AnnotationOutputter.Options options) {
            this.writer = writer;
            this.options = options;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void routeObject(int indent, Object value) {
            if (value instanceof String) {
                this.writer.write("\"");
                this.writer.write(JSONOutputter.cleanJSON(value.toString()));
                this.writer.write("\"");
                return;
            } else if (value instanceof Collection) {
                this.writer.write("[");
                this.newline();
                Iterator elems = ((Collection)value).iterator();
                while (elems.hasNext()) {
                    this.indent(indent + 1);
                    this.routeObject(indent + 1, elems.next());
                    if (elems.hasNext()) {
                        this.writer.write(",");
                    }
                    this.newline();
                }
                this.indent(indent);
                this.writer.write("]");
                return;
            } else if (value instanceof Enum) {
                this.writer.write("\"");
                this.writer.write(JSONOutputter.cleanJSON(((Enum)value).name()));
                this.writer.write("\"");
                return;
            } else if (value instanceof Pair) {
                this.routeObject(indent, Arrays.asList(((Pair)value).first, ((Pair)value).second));
                return;
            } else if (value instanceof Span) {
                this.writer.write("[");
                this.writer.write(Integer.toString(((Span)value).start()));
                this.writer.write(",");
                this.space();
                this.writer.write(Integer.toString(((Span)value).end()));
                this.writer.write("]");
                return;
            } else if (value instanceof Consumer) {
                this.object(indent, (Consumer)value);
                return;
            } else if (value instanceof Stream) {
                this.routeObject(indent, ((Stream)value).collect(Collectors.toList()));
                return;
            } else if (value.getClass().isArray()) {
                Class<?> componentType = value.getClass().getComponentType();
                if (componentType.isPrimitive()) {
                    if (Integer.TYPE.isAssignableFrom(componentType)) {
                        ArrayList<Integer> lst = new ArrayList<Integer>();
                        for (int elem : (int[])value) {
                            lst.add(elem);
                        }
                        this.routeObject(indent, lst);
                        return;
                    } else if (Short.TYPE.isAssignableFrom(componentType)) {
                        ArrayList<Short> lst = new ArrayList<Short>();
                        for (short elem : (short[])value) {
                            lst.add(elem);
                        }
                        this.routeObject(indent, lst);
                        return;
                    } else if (Byte.TYPE.isAssignableFrom(componentType)) {
                        ArrayList<Byte> lst = new ArrayList<Byte>();
                        for (byte elem : (byte[])value) {
                            lst.add(elem);
                        }
                        this.routeObject(indent, lst);
                        return;
                    } else if (Long.TYPE.isAssignableFrom(componentType)) {
                        ArrayList<Long> lst = new ArrayList<Long>();
                        for (long elem : (long[])value) {
                            lst.add(elem);
                        }
                        this.routeObject(indent, lst);
                        return;
                    } else if (Character.TYPE.isAssignableFrom(componentType)) {
                        ArrayList<Character> lst = new ArrayList<Character>();
                        for (char elem : (char[])value) {
                            lst.add(Character.valueOf(elem));
                        }
                        this.routeObject(indent, lst);
                        return;
                    } else if (Float.TYPE.isAssignableFrom(componentType)) {
                        ArrayList<Float> lst = new ArrayList<Float>();
                        for (float elem : (float[])value) {
                            lst.add(Float.valueOf(elem));
                        }
                        this.routeObject(indent, lst);
                        return;
                    } else if (Double.TYPE.isAssignableFrom(componentType)) {
                        ArrayList<Double> lst = new ArrayList<Double>();
                        for (double elem : (double[])value) {
                            lst.add(elem);
                        }
                        this.routeObject(indent, lst);
                        return;
                    } else {
                        if (!Boolean.TYPE.isAssignableFrom(componentType)) throw new IllegalStateException("Unhandled primitive type in array: " + componentType);
                        ArrayList<Boolean> lst = new ArrayList<Boolean>();
                        for (boolean elem : (boolean[])value) {
                            lst.add(elem);
                        }
                        this.routeObject(indent, lst);
                    }
                    return;
                } else {
                    this.routeObject(indent, Arrays.asList((Object[])value));
                }
                return;
            } else if (value instanceof Integer) {
                this.writer.write(Integer.toString((Integer)value));
                return;
            } else if (value instanceof Short) {
                this.writer.write(Short.toString((Short)value));
                return;
            } else if (value instanceof Byte) {
                this.writer.write(Byte.toString((Byte)value));
                return;
            } else if (value instanceof Long) {
                this.writer.write(Long.toString((Long)value));
                return;
            } else if (value instanceof Character) {
                this.writer.write(Character.toString(((Character)value).charValue()));
                return;
            } else if (value instanceof Float) {
                this.writer.write(new DecimalFormat("0.#######").format(value));
                return;
            } else if (value instanceof Double) {
                this.writer.write(new DecimalFormat("0.##############").format(value));
                return;
            } else if (value instanceof Boolean) {
                this.writer.write(Boolean.toString((Boolean)value));
                return;
            } else if (Integer.TYPE.isAssignableFrom(value.getClass())) {
                this.routeObject(indent, (int)((Integer)value));
                return;
            } else if (Short.TYPE.isAssignableFrom(value.getClass())) {
                this.routeObject(indent, (short)((Short)value));
                return;
            } else if (Byte.TYPE.isAssignableFrom(value.getClass())) {
                this.routeObject(indent, (byte)((Byte)value));
                return;
            } else if (Long.TYPE.isAssignableFrom(value.getClass())) {
                this.routeObject(indent, (long)((Long)value));
                return;
            } else if (Character.TYPE.isAssignableFrom(value.getClass())) {
                this.routeObject(indent, Character.valueOf(((Character)value).charValue()));
                return;
            } else if (Float.TYPE.isAssignableFrom(value.getClass())) {
                this.routeObject(indent, Float.valueOf(((Float)value).floatValue()));
                return;
            } else if (Double.TYPE.isAssignableFrom(value.getClass())) {
                this.routeObject(indent, (double)((Double)value));
                return;
            } else {
                if (!Boolean.TYPE.isAssignableFrom(value.getClass())) throw new RuntimeException("Unknown object to serialize: " + value);
                this.routeObject(indent, (boolean)((Boolean)value));
            }
        }

        public void object(int indent, Consumer<Writer> callback) {
            this.writer.write("{");
            Pointer<Boolean> firstCall = new Pointer<Boolean>(true);
            callback.accept((key, value) -> {
                if (key != null && value != null) {
                    if (!((Boolean)firstCall.dereference().get()).booleanValue()) {
                        this.writer.write(",");
                    }
                    firstCall.set(false);
                    this.newline();
                    this.indent(indent + 1);
                    this.writer.write("\"");
                    this.writer.write(JSONOutputter.cleanJSON(key));
                    this.writer.write("\":");
                    this.space();
                    this.routeObject(indent + 1, value);
                }
            });
            this.newline();
            this.indent(indent);
            this.writer.write("}");
        }

        public void object(Consumer<Writer> callback) {
            this.object(0, callback);
        }

        private void indent(int num) {
            if (this.options.pretty) {
                for (int i = 0; i < num; ++i) {
                    this.writer.write(JSONOutputter.INDENT_CHAR);
                }
            }
        }

        private void space() {
            if (this.options.pretty) {
                this.writer.write(" ");
            }
        }

        private void newline() {
            if (this.options.pretty) {
                this.writer.write("\n");
            }
        }

        public static String objectToJSON(Consumer<Writer> callback) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            PrintWriter out2 = new PrintWriter(os);
            new JSONWriter(out2, new AnnotationOutputter.Options()).object(callback);
            out2.close();
            return ((Object)os).toString();
        }
    }
}

