/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ie.machinereading.BasicRelationExtractor;
import edu.stanford.nlp.ie.machinereading.MachineReading;
import edu.stanford.nlp.ie.machinereading.domains.roth.RothCONLL04Reader;
import edu.stanford.nlp.ie.machinereading.domains.roth.RothEntityExtractor;
import edu.stanford.nlp.ie.machinereading.structure.EntityMention;
import edu.stanford.nlp.ie.machinereading.structure.MachineReadingAnnotations;
import edu.stanford.nlp.ie.machinereading.structure.RelationMention;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.util.ArraySet;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.StringUtils;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class RelationExtractorAnnotator
implements Annotator {
    MachineReading mr;
    private static boolean verbose = false;

    public RelationExtractorAnnotator(Properties props) {
        verbose = Boolean.parseBoolean(props.getProperty("sup.relation.verbose", "false"));
        String relationModel = props.getProperty("sup.relation.model", "edu/stanford/nlp/models/supervised_relation_extractor/roth_relation_model_pipelineNER.ser");
        try {
            RothEntityExtractor entityExtractor = new RothEntityExtractor();
            BasicRelationExtractor relationExtractor = BasicRelationExtractor.load(relationModel);
            System.err.println("Loading relation model from " + relationModel);
            this.mr = MachineReading.makeMachineReadingForAnnotation(new RothCONLL04Reader(), entityExtractor, relationExtractor, null, null, null, true, verbose);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    public void annotate(Annotation annotation) {
        Annotation output = this.mr.annotate(annotation);
        List outputSentences = (List)output.get(CoreAnnotations.SentencesAnnotation.class);
        List origSentences = (List)annotation.get(CoreAnnotations.SentencesAnnotation.class);
        for (int i = 0; i < outputSentences.size(); ++i) {
            CoreMap outSent = (CoreMap)outputSentences.get(i);
            CoreMap origSent = (CoreMap)origSentences.get(i);
            List entities = (List)outSent.get(MachineReadingAnnotations.EntityMentionsAnnotation.class);
            origSent.set(MachineReadingAnnotations.EntityMentionsAnnotation.class, entities);
            if (verbose && entities != null) {
                System.err.println("Extracted the following entities:");
                for (EntityMention e : entities) {
                    System.err.println("\t" + e);
                }
            }
            List relations = (List)outSent.get(MachineReadingAnnotations.RelationMentionsAnnotation.class);
            origSent.set(MachineReadingAnnotations.RelationMentionsAnnotation.class, relations);
            if (!verbose || relations == null) continue;
            System.err.println("Extracted the following relations:");
            for (RelationMention r : relations) {
                if (r.getType().equals("_NR")) continue;
                System.err.println(r);
            }
        }
    }

    @Override
    public Set<Annotator.Requirement> requires() {
        return new ArraySet<Annotator.Requirement>(TOKENIZE_REQUIREMENT, SSPLIT_REQUIREMENT, POS_REQUIREMENT, NER_REQUIREMENT, PARSE_REQUIREMENT);
    }

    @Override
    public Set<Annotator.Requirement> requirementsSatisfied() {
        return Collections.singleton(RELATION_EXTRACTOR_REQUIREMENT);
    }

    public static void main(String[] args) {
        try {
            Properties props = StringUtils.argsToProperties(args);
            props.setProperty("annotators", "tokenize,ssplit,lemma,pos,parse,ner");
            StanfordCoreNLP pipeline = new StanfordCoreNLP();
            String sentence = "Barack Obama lives in America. Obama works for the Federal Goverment.";
            Annotation doc = new Annotation(sentence);
            pipeline.annotate(doc);
            RelationExtractorAnnotator r = new RelationExtractorAnnotator(props);
            r.annotate(doc);
            for (CoreMap s : (List)doc.get(CoreAnnotations.SentencesAnnotation.class)) {
                System.out.println("For sentence " + (String)s.get(CoreAnnotations.TextAnnotation.class));
                List rls = (List)s.get(MachineReadingAnnotations.RelationMentionsAnnotation.class);
                for (RelationMention rl : rls) {
                    System.out.println(rl.toString());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

