/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.scoref;

import edu.stanford.nlp.scoref.CompressedFeatureVector;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class Compressor<K>
implements Serializable {
    private static final long serialVersionUID = 364548642855692442L;
    private final Map<K, Integer> index = new HashMap<K, Integer>();
    private final Map<Integer, K> inverse = new HashMap<Integer, K>();

    public CompressedFeatureVector compress(Counter<K> c) {
        ArrayList<Integer> keys = new ArrayList<Integer>(c.size());
        ArrayList<Double> values = new ArrayList<Double>(c.size());
        for (Map.Entry<K, Double> e : c.entrySet()) {
            K key = e.getKey();
            Integer id = this.index.get(key);
            if (id == null) {
                id = this.index.size();
                this.inverse.put(id, (Integer)key);
                this.index.put(key, id);
            }
            keys.add(id);
            values.add(e.getValue());
        }
        return new CompressedFeatureVector(keys, values);
    }

    public Counter<K> uncompress(CompressedFeatureVector cvf) {
        ClassicCounter<K> c = new ClassicCounter<K>();
        for (int i = 0; i < cvf.keys.size(); ++i) {
            c.incrementCount(this.inverse.get(cvf.keys.get(i)), cvf.values.get(i));
        }
        return c;
    }
}

