/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class ArrayMap<K, V>
extends AbstractMap<K, V>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Entry<K, V>[] entryArray;
    private int capacity;
    private int size;
    protected int hashCodeCache;

    public ArrayMap() {
        this.size = 0;
        this.capacity = 2;
        this.entryArray = new Entry[2];
    }

    public ArrayMap(int capacity) {
        this.size = 0;
        this.capacity = capacity;
        this.entryArray = new Entry[capacity];
    }

    public ArrayMap(Map<? extends K, ? extends V> m) {
        this.size = 0;
        this.capacity = m.size();
        this.entryArray = new Entry[m.size()];
        this.putAll(m);
    }

    public ArrayMap(K[] keys, V[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("different number of keys and values.");
        }
        this.capacity = this.size = keys.length;
        this.entryArray = new Entry[this.size];
        for (int i = 0; i < keys.length; ++i) {
            this.entryArray[i] = new Entry<K, V>(keys[i], values[i]);
        }
    }

    public static <K, V> ArrayMap<K, V> newArrayMap() {
        return new ArrayMap<K, V>();
    }

    public static <K, V> ArrayMap<K, V> newArrayMap(int capacity) {
        return new ArrayMap<K, V>(capacity);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new HashSet<Map.Entry<K, V>>(Arrays.asList(this.entryArray).subList(0, this.size)){
            private static final long serialVersionUID = 2746535724049192751L;

            @Override
            public boolean remove(Object o) {
                if (o instanceof Map.Entry) {
                    Map.Entry entry = (Map.Entry)o;
                    ArrayMap.this.remove(entry.getKey());
                    return super.remove(o);
                }
                return false;
            }

            @Override
            public void clear() {
                super.clear();
                ArrayMap.this.clear();
            }
        };
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    private void resize() {
        Entry<K, V>[] oldEntryArray = this.entryArray;
        int newCapacity = 2 * this.size;
        if (newCapacity == 0) {
            newCapacity = 1;
        }
        this.entryArray = new Entry[newCapacity];
        System.arraycopy(oldEntryArray, 0, this.entryArray, 0, this.size);
        this.capacity = newCapacity;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public V put(K key, V val) {
        for (int i = 0; i < this.size; ++i) {
            if (!key.equals(this.entryArray[i].getKey())) continue;
            return this.entryArray[i].setValue(val);
        }
        if (this.capacity <= this.size) {
            this.resize();
        }
        this.entryArray[this.size] = new Entry<K, V>(key, val);
        ++this.size;
        return null;
    }

    @Override
    public V get(Object key) {
        for (int i = 0; i < this.size; ++i) {
            if (!(key == null ? this.entryArray[i].getKey() == null : key.equals(this.entryArray[i].getKey()))) continue;
            return this.entryArray[i].getValue();
        }
        return null;
    }

    @Override
    public V remove(Object key) {
        for (int i = 0; i < this.size; ++i) {
            if (!(key == null ? this.entryArray[i].getKey() == null : key.equals(this.entryArray[i].getKey()))) continue;
            V value = this.entryArray[i].getValue();
            if (this.size > 1) {
                this.entryArray[i] = this.entryArray[this.size - 1];
            }
            --this.size;
            return value;
        }
        return null;
    }

    @Override
    public int hashCode() {
        if (this.hashCodeCache == 0) {
            int hashCode = 5381;
            for (int i = 0; i < this.size; ++i) {
                hashCode = hashCode * 33 + this.entryArray[i].hashCode();
            }
            this.hashCodeCache = hashCode;
        }
        return this.hashCodeCache;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        for (int i = 0; i < this.size; ++i) {
            Object mVal = m.get(this.entryArray[i].getKey());
            if (!(mVal == null ? this.entryArray[i] != null : !m.get(this.entryArray[i].getKey()).equals(this.entryArray[i].getValue()))) continue;
            return false;
        }
        return true;
    }

    static final class Entry<K, V>
    implements Map.Entry<K, V>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final K key;
        private V value;

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V o) {
            V old = this.value;
            this.value = o;
            return old;
        }

        @Override
        public int hashCode() {
            return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry e = (Entry)o;
            return (this.getKey() == null ? e.getKey() == null : this.getKey().equals(e.getKey())) && (this.getValue() == null ? e.getValue() == null : this.getValue().equals(e.getValue()));
        }

        Entry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

